/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab.csv;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.tab.TabularLoader;
import cz.insophy.inplan.tab.csv.CsvLoader;
import cz.insophy.inplan.tab.csv.CsvSettings;
import cz.insophy.inplan.util.NameUtils;
import cz.insophy.inplan.util.errlog.ErrorLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CsvsLoader
implements TabularLoader {
    private static final Logger log = LoggerFactory.getLogger(CsvsLoader.class);
    final CsvLoader l;
    private final Set<Class<?>> loadedClasses;

    private CsvsLoader(ErrorLog errorLog) {
        this.l = new CsvLoader(errorLog);
        this.loadedClasses = Sets.newIdentityHashSet();
    }

    @Override
    public <T> Iterable<T> load(Class<T> cls) throws IOException {
        Reader reader = this.openReader(cls);
        boolean logErrors = this.loadedClasses.add(cls);
        return this.l.load(reader, this.getSourceName(cls), cls, false, logErrors);
    }

    @Override
    public <T> List<T> loadList(Class<T> cls) throws IOException {
        return Lists.newArrayList(this.load(cls));
    }

    protected abstract <T> Reader openReader(Class<T> var1) throws IOException;

    protected abstract String getSourceName(Class<?> var1);

    public static CsvsLoader fromDirectory(@Nonnull Path dir, @Nonnull ErrorLog errorLog) throws IOException {
        Map<String, Path> lcNames;
        Preconditions.checkNotNull(dir, "dir");
        try (Stream<Path> files = Files.list(dir);){
            lcNames = files.collect(Collectors.toMap(p -> p.getFileName().toString().toLowerCase(), p -> p));
        }
        return new CsvsLoader(errorLog){

            @Override
            protected <T> Reader openReader(Class<T> cls) throws IOException {
                Path p = (Path)lcNames.get(this.getSourceName(cls));
                if (p != null) {
                    log.info("Loading CSV from " + p);
                    return Files.newBufferedReader(p, CsvSettings.getCharset());
                }
                log.warn("Faking empty source for " + this.getSourceName(cls));
                return new StringReader("");
            }

            @Override
            protected String getSourceName(Class<?> cls) {
                return "data_src_" + NameUtils.toUnderscoreCase(cls.getSimpleName()) + ".csv";
            }
        };
    }

    public static CsvsLoader fromMap(final Map<String, byte[]> map, @Nonnull ErrorLog errorLog) {
        Preconditions.checkNotNull(map);
        return new CsvsLoader(errorLog){

            @Override
            protected <T> Reader openReader(Class<T> cls) throws IOException {
                String srcName = this.getSourceName(cls);
                byte[] data = (byte[])map.get(srcName);
                if (data == null) {
                    throw new IllegalStateException("Cannot find " + srcName);
                }
                return new InputStreamReader((InputStream)new ByteArrayInputStream(data), CsvSettings.getCharset());
            }

            @Override
            protected String getSourceName(Class<?> cls) {
                return "DATA_SRC_" + NameUtils.toConstantCase(cls.getSimpleName());
            }
        };
    }
}

